﻿<?LassoScript

	// Mailing Labels demo for Lasso Summit 2007
	// Author Jolle Carlestam
	// Inspired by a TOTW example by Fletcher Sandbeck 2004
	// Use and alter freely but please keep this info




	// Preparation of demo content. This should be replaced with your own record content handling.
	// The demo assumes that the files Contacts.incl and jina_prepPDF_demo.incl
	// are in the same folder and can be accessed by Lasso.
	Include:'ex_cont/jina_prepPDF_demo.incl';
	var:'allData' = jina_prepContacts: (Include:'ex_cont/Contacts.incl');


	// For testing purposes rectangles are drawn on the mailing labels sheet.
	// Use this variable to turn these rectangles off for actual label printing.
	var: 'drawRects' = true;

	// If you only want the first page while testing set this to true.
	var:'firstPageonly' = false;

	//#####################################################################//
	// Settings that control the look and layout of the label sheets.
	// These demo settings are suitable for an A4 page with Avery 7160 labels 3 cols 7 rows.

	// The number of rows and columns of labels.
	var:'labelRows' = 7;
	var:'labelCols' = 3;


	// These variables set the font face and leading.
	var:'textFont' = (pdf_font: -face = 'Helvetica', -size = 10);
	var:'textHeight' = 13;

	var:'pageSize' = 'A4';
	var:'pageHeight' = 842;

	// The top and left margin for the page 
	// (where the upper left label is located), in points.
	var:'marginTop' = 45;
	var:'marginLeft' = 25;
	
	// The width and height of each label
	var:'labelWidth' = 174;
	var:'labelHeight' = 107;
	
	// The width between label columns and height between label rows (if any).
	var:'marginWidth' = 14;
	var:'marginHeight' = 1;

	// Setting a default country that will not show up in address fields 
	// in the invoice. All other countries will.
	var:'defaultCountry' = 'USA';

	//#####################################################################//

	// Vars set to be used by the application. Do not change these.
	var:'newPageCheck' = $labelRows * $labelCols;
	var:'labelData' = array;
	var:'labelArray' = array;
	var:'labelTemp' = string;
	var:'prepLabel' = string;
	var:'labelVerSize' = integer;
	var:'colPos' = integer;
	var:'rowCount' = integer;
	var:'labelLeft' = integer;
	var:'labelTop' = integer;

	
	// Create the PDF file.
	var:'pdfTemplate' = (pdf_doc:
		-nocompress,
		-size = $pageSize,
		-title = 'Labels',
		-author = 'jinaOnline',
		-margins = (array: 0,0,0,0)
		);

	$pdfTemplate->(setcolor: 'stroke', 'rgb', .75, .75, .75);

	// Iterate all contacts. This would probably be a Records container in the real world.
	iterate: $allData, $labelData; // $labelData now holds all info for one contact in an array.

		if:($rowCount) == $labelRows; // Time to move one column and reset label row.
			$colPos += 1;
			$rowCount = 0;
		/if;

		// Set this labels position.
		$labelLeft = $marginLeft + (($labelWidth + $marginWidth) * $colPos);
		$labelTop = $marginTop + (($labelHeight + $marginHeight) * $rowCount);

		$rowCount += 1;

		if: $drawRects; // Adjusted for graphic coordinates starting at lower left.
			$pdfTemplate->(rect: $labelLeft, ($pageHeight - $labelTop - $labelHeight), $labelWidth, $labelHeight);
		/if;

		$prepLabel = (jina_prepLabel: $labelData, $defaultCountry); // $prepLabel now holds the actual label content.
		// In the real world the content would be collected from several different fields.

		// Calculate the number of rows within the label this content will occupy.
		$labelArray = $prepLabel->(split:'\r');
		$labelVerSize = $labelArray->Size; // This gives us all hardcoded line feeds.

		iterate:  $labelArray, $labelTemp;
			// This adds rows if the content flows over more than one row.
			$labelVerSize += math_floor(($textFont->(textwidth: $labelTemp)) / ($labelWidth - 12));
		/iterate;

		$labelVerSize *= $textHeight;

		// Time to add this label content to the pdf.
		$pdfTemplate->(Add: 
			(PDF_Text: $prepLabel,
				-type = 'paragraph', -font = $textFont),
			-width = $labelWidth - 12,
			-left = $labelLeft + 6,
			-top = $labelTop + (($labelHeight - $labelVerSize) / 2) - ($textHeight / 2), // Centres the label content vertically
			-height = Math_Min(($labelVerSize),$labelHeight), // Makes sure the content won't grow into the next label.
			-align = 'left', 
			-leading = $textHeight);

		if:loop_count % $newPageCheck == 0; // Time for a new page. Reset counters.
			(($firstPageonly) ? loop_abort);
			$colPos = integer;
			$rowCount = integer;

			$pdfTemplate->AddPage;
		/if;

	/iterate;

// Serve the PDF.
	$pdfTemplate->close;
	pdf_serve: -content = $pdfTemplate, -file = 'Jina Demo Labels.pdf';


?>